/* strsep.c
   This method returns string tokens from a source string, where tokens are separated by the specified characters. This version
   will return blank tokens between field seperators, similar to the cut command does.
   The input parameter stringp is a bit odd--seems a char * would have been fine, but the standard from the C string library was
   used.
   change log:
   08/20/2023 initial version
   12/10/2023 removed reference to string_ext.h
   10/11/2025 corrected strsep behavior to allow for multiple simultaneous sessions
*/

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include <dylib.h>

char *strsep (char **stringp, const char *delim) {

   if (*stringp == NULL) {
      return NULL;
   }

   char *src = *stringp;         // capture the source, for simplicity of the code
   char *p;                      // pointer for seperators
   char *r = NULL;               // the return value

   char *s = src;                // initialize s with the current source
   while (*s != 0x00) {          // loop through s
      p = (char *) delim;        // get the first delimiter
      while (*p != 0x00) {       // loop through all separators
         if (*s == *p) {         // if found, then break
            break;
         }
         p++;                    // advance to the next separator
      }
      if (*p != 0x00) {          // check if a separator is found on *s
         *s  = 0x00;             // it was, so null terminate the separator found
         s++;                    // advance to the next position
         r   = src;              // set the return value
         src = s;                // set src to the next position after the separator
         break;                  // break out of the while loop
      }
      s++;                       // advance to the next position in s
   }
   if (!r) {
      if (dylib.strlen (src)) {  // handle case where there were no more seperators found but src still has some text
         r    = src;             // set the return to the remainder of src
         src += dylib.strlen (src);    // advance src to the end
      }
   }
   *stringp = src;
   return r;                     // return the result
}
