/* strstr.c
   This method finds the first occurance of one string in another.
   change log:
   06/23/2023 initial version
   12/10/2023 removed reference to string_ext.h
*/

#include <string.h>
#include <dylib.h>

char *strstr (const char *haystack, const char *needle) {

   char *h;
   char *n;
   char *found = 0;
   char *last  = 0;
   char *end_n = (char *) needle + dylib.strlen (needle);
   h = (char *) haystack;
   n = (char *) needle;

   // loop through all of haystack
   while (*h != 0) {
      // look for a match between these haystack and needle positions
      if (*h == *n) {
         // have a match
         n++;                      // advance the needle position
         if (last == 0) last = h;  // capture this found location if not already captured previously
         if (n == end_n) {         // test if the matching has reached the end of the needle
            found = last;          // matched. Set the value and exit the while loop
            break;
         }
      } else {             
         // no match
         if (last) {                   // clear found information if present
            h       = last;            // jump back to the position where part of the needle was found, but not fully matched
            n       = (char *) needle; // reset the needle position
            last    = 0;               // prepare for another position to be found
         }
      }
      h++; // advance the haystack position
   }
   return found;
}
