/* strtok.c
   This method returns string tokens from a source string, where tokens are separated by the specified characters.
   change log:
   06/23/2023 initial version
   12/10/2023 removed reference to string_ext.h
   02/24/2024 modified to use dylib for storage
*/

#include <dylib.h>
#include <string.h>

// static char *strtok_lasts;

char * strtok (char *restrict str, const char *restrict sep) {
   int ch;

   if (str == 0) str = dylib.strtok_lasts;
   do {
      if ((ch = *str++) == '\0') return 0;
   } while (strchr (sep, ch));
   --str;
   dylib.strtok_lasts = str + strcspn (str, (char *) sep);
   if (*dylib.strtok_lasts != 0) *dylib.strtok_lasts++ = 0;
   return str;
}
