/* time_tm_ide.c
   This method implements the method for collecting time from the IDE controller.
   change history
   06/13/2025 initial version
   06/15/2025 added test for DSR existence
   06/17/2025 added day of year
   06/24/2025 renamed file_is_valid_path to file_has_valid_dsr_name
   07/05/2025 dylib adjustments
   10/13/2025 changed ref from file_has_valid_dsr_name to file_get_dsr_cru
*/

#include <stdio.h>
#include <vdp.h>
#include <dylib.h>
#include <time.h>
#include <time_private.h>
#include <dirent_private.h>
#include <stdio_private.h>
#include <stdlib.h>

struct tm *time_tm_ide (void) {

   struct tm *r = NULL;
   char s[32];

   char final_ti_path[FILENAME_MAX];
   dylib.strcpy (final_ti_path, IDE_DATE_PATH);

   if (file_get_dsr_cru (final_ti_path)) {          // determine if the IDE date path exists -- it'll have a valid cru

      FILE *f = dylib.file_get_available (true);

      if (f) {

         dylib.strcpy (f->dsr->pab_filename, final_ti_path);
         f->dsr->pab.NameLength   = dylib.strlen (f->dsr->pab_filename);
         f->dsr->pab.pName        = (unsigned char *)f->dsr->pab_filename;
         f->dsr->pab.OpCode       = DSR_OPEN;
         f->dsr->pab.Status       = DSR_TYPE_INPUT | DSR_TYPE_INTERNAL | DSR_TYPE_FIXED;
         f->dsr->pab.RecordNumber = 0;
         f->dsr->pab.ScreenOffset = 0x00;
         f->dsr->pab.RecordLength = 0;
         f->dsr->pab.VDPBuffer    = f->dsr->vdp_data_buffer_addr;
   
         int fr = dylib.dsrlnk (&f->dsr->pab, f->dsr->vdp_pab_buffer_addr);
         if (!fr) {
   
            f->dsr->pab.OpCode = DSR_READ;
            dylib.dsrlnk (&f->dsr->pab, f->dsr->vdp_pab_buffer_addr);
   
            char buf[150];
   
            // get the length of the read data
            vdpmemread (f->dsr->vdp_pab_buffer_addr + 5, (unsigned char *) &f->dsr->pab.CharCount, 1);
            // copy read data from vdp to ram
            vdpmemread (f->dsr->vdp_data_buffer_addr, (unsigned char *) buf, f->dsr->pab.CharCount);
   
            char *cursor = buf;
            char len;
   
            cursor = memcpy_cursor (&len, cursor, sizeof (char));
            cursor = memcpy_cursor (s, cursor, len);
            s[(int) len] = 0x00;
            stm.tm_sec = atoi (s);
   
            cursor = memcpy_cursor (&len, cursor, sizeof (char));
            cursor = memcpy_cursor (s, cursor, len);
            s[(int) len] = 0x00;
            stm.tm_min = atoi (s);
   
            cursor = memcpy_cursor (&len, cursor, sizeof (char));
            cursor = memcpy_cursor (s, cursor, len);
            s[(int) len] = 0x00;
            stm.tm_hour = atoi (s);
   
            cursor = memcpy_cursor (&len, cursor, sizeof (char));
            cursor = memcpy_cursor (s, cursor, len);
            s[(int) len] = 0x00;
            stm.tm_mday = atoi (s);
   
            cursor = memcpy_cursor (&len, cursor, sizeof (char));
            cursor = memcpy_cursor (s, cursor, len);
            s[(int) len] = 0x00;
            stm.tm_mon = atoi (s) - 1;
   
            cursor = memcpy_cursor (&len, cursor, sizeof (char));
            cursor = memcpy_cursor (s, cursor, len);
            s[(int) len] = 0x00;
            stm.tm_year = atoi (s);
   
            cursor = memcpy_cursor (&len, cursor, sizeof (char));
            cursor = memcpy_cursor (s, cursor, len);
            s[(int) len] = 0x00;
            stm.tm_wday = atoi (s) - 1;
 
            stm.tm_yday = get_day_of_year (stm.tm_mday, stm.tm_mon, stm.tm_year);
  
            r = &stm;
   
            f->dsr->pab.OpCode = DSR_CLOSE;
            fr = dylib.dsrlnk (&f->dsr->pab, f->dsr->vdp_pab_buffer_addr);
         }
      }
   }

   return r;
}
