/* time_tm_tipi.c
   This method implements collection of time via TIPI.
   change history
   06/13/2025 initial version
   06/17/2025 added day of year
*/

#include <time.h>
#include <time_private.h>
#include <stdio.h>
#include <dylib.h>
#include <stdlib.h>

struct tm *time_tm_tipi (void) {

   struct tm *r = NULL;

   char s[80];         // the input format
   char field[3][24];  // fields for processing the clock read
   char *p;            // pointer for parsing data

   FILE *f = dylib.fopen (TIPI_DATE_PATH, "r");        // open the file
   if (f) {                                       // confirm the file opened
      if (dylib.fgets (s, sizeof (s), f)) { // read the file and confirm data was indeed read

         // clock format is w,mm/dd/yy,HH:MM:SS

         // capture the three fields separated by commas
         p = dylib.strtok (s, ",");
         dylib.strcpy (field[0], p);
         p = dylib.strtok (NULL, ",");
         dylib.strcpy (field[1], p);
         p = dylib.strtok (NULL, ",");
         dylib.strcpy (field[2], p);

         // capture the day of week
         stm.tm_wday = atoi (field[0]);

         // capture the date
         p = dylib.strtok (field[1], "/");
         stm.tm_mon = atoi (p) - 1;
         p = dylib.strtok (NULL, "/");
         stm.tm_mday = atoi (p);
         p = dylib.strtok (NULL, "/");
         stm.tm_year = atoi (p) + 2000;

         // capture the time
         p = dylib.strtok (field[2], ":");
         stm.tm_hour = atoi (p);
         p = dylib.strtok (NULL, ":");
         stm.tm_min = atoi (p);
         p = dylib.strtok (NULL, ":");
         stm.tm_sec = atoi (p);

         stm.tm_yday = get_day_of_year (stm.tm_mday, stm.tm_mon, stm.tm_year);

         r = &stm;
      }
      dylib.fclose (f);
   }

   return r;
}
