/* tipi_keyboard.c
   This package provides the implementation for the tipi keyboard.
   change history
   04/16/2025 initial version, adapted from tipi_mouse.c from github
   04/21/2025 added tipiKeyboardAvailable
*/

#include <tipi_keyboard.h>
#include <tipi_msg.h>

char keyboarddata[3];

void tipiKeyboardRead () {
   unsigned char keyboardcode = 0x60;
   int readcount = 0;
   tipi_on ();
   tipi_sendmsg (1, (unsigned char*)&keyboardcode);
   tipi_recvmsg (&readcount, (unsigned char*)&keyboarddata);
   tipi_off ();

   if (!readcount) {
      keyboarddata[0] = 0x00;
   }
}

void tipiKeyboardAvailable () {
   unsigned char keyboardcode = 0x61;
   int readcount = 0;
   tipi_on ();
   tipi_sendmsg (1, (unsigned char*)&keyboardcode);
   tipi_recvmsg (&readcount, (unsigned char*)&keyboarddata);
   tipi_off ();

   if (!readcount) {
      keyboarddata[0] = 0x00;
   }
}
