/* uint2hex.c
   change log:
   12/10/2023 added header
   10/18/2025 modified to use dylib.num2str_buf as the return
   12/12/2025 size and performance improvements
*/ 

#include <conversion.h>
#include <dylib.h>

char *uint2hex (unsigned int v) {
   unsigned int k;
   char *o = dylib.num2str_buf + 4;
   *o = 0x00;
   o--;

   for (int i = 0; i < 4; i++) {
      k = 0x000f & v;
      v >>= 4;
      if (k > 9) {
         *o = k + 55; // A-F
      } else {
         *o = k + 48; // 0-9
      }
      o--;
   }

   return dylib.num2str_buf;
}

/*
char *uint2hex (unsigned int x) {

   char *out = dylib.num2str_buf;

   unsigned int div = 0x1000;
   int digit = 0;
  
   while (div > 0) {
      digit = x/div;
      x = x % div;
      if (digit > 9) {
         *(out++) = digit - 10 + 'A';
      } else {
         *(out++) = digit + '0';
      }
      div /= 0x10;
   }
   *out = '\0';
   return dylib.num2str_buf;
}
*/
