/* uitof.c
   This method converts an unsigned integer into a floating point.
   06/23/2023 initial version
   11/15/2025 made idigit static to hide its visibility
*/

#include <conversion.h>

// base 10 digit values
static const int idigit[] = {0, 10000, 1000, 100, 10};

// converts an integer to floating point
double uitof (unsigned int k) {
   double d;
   char *w = (char *) &d; 
   int v[14] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
   int p = 0;             
   char e;
   int i;
   int t;

   if (k == 0) {
      for (i = 0; i < 8; i++) {
         *w = 0x00;
         w++;
      }
   } else {
      for (i = 1; i < 5; i++) {
         v[i] = k / idigit[i];
         k   -= v[i] * idigit[i];
         if ( (v[i])  && (p == 0) ) p = 5 - i;
      } 
      v[5] = k;
  
      e = 0x40 + p / 2;
      *w = e;
      w++;

      int s = ((5 - p) / 2) * 2;
      for (i = s; i < 14; i += 2) {
         t  = v[i] * 10 + v[i + 1];
         *w = t;
         w++;
      }
   }
   return d;
}
