/* ultoa.c 
   This method converts from an unsigned long to its ascii representation.
   limitations:
   This method is extremely inefficient due to emulated div and mod
   change log:
   12/29/2023 initial version
*/

#include <conversion.h>

#define DIGITS_MAX 10

static const unsigned long div_mod_pvd[DIGITS_MAX] = 
   {1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};

const char *ultoa (unsigned long x) {
  static char strbuf[16];
  char *out = strbuf;
  int digit;
  int has_first_digit = 0;
  int i;
  int si;

  // speed up this inefficient method by determining which div_mod_pvd index from which to start
  si = DIGITS_MAX;
  for (i = 0; i < DIGITS_MAX; i++) {
     if (x >= div_mod_pvd[i]) {
        si = i;
        break;
     }
  }

  // walk through every required digit index, starting at si
  for (i = si; i < DIGITS_MAX; i++) {
     digit = 0;
     while (x >= div_mod_pvd[i]) {
        digit++;
        x -= div_mod_pvd[i];
     }
     if (digit > 0) has_first_digit = 1;
     if (has_first_digit) {
        *(out++) = '0' + (char) digit;
     }
  }

  // after all the above, if no first digit as found, then the input value is zero
  if (!has_first_digit) {
     *(out++) = '0';
  }

  *(out) = 0;

  return strbuf;
}
