/* uname.c
   This method returns system information.
   change log:
   11/02/2023 initial version
   06/02/2025 added use of dylib
*/

#include <utsname.h>
#include <system_private.h>
#include <string.h>
#include <dylib.h>

int uname (struct utsname *name) {

   dylib.strcpy (name->sysname, SYSTEM_OS_IMPLEMENTATION);
   dylib.strcpy (name->nodename, SYSTEM_HOSTNAME);
   dylib.strcpy (name->release, SYSTEM_OS_RELEASE_LEVEL);
   dylib.strcpy (name->version, SYSTEM_OS_RELEASE_VERSION);
   dylib.strcpy (name->machine, SYSTEM_HARDWARE_PLATFORM);
   dylib.strcpy (name->proc_arch, SYSTEM_PROCESSOR_ARCH);

   return 0;
}
