/* dylib_rom1_link.c
   This method performs link for the dylib for ROM methods.
   change log:
   02/22/2024 initial version
   02/24/2024 added multiple methods
   02/25/2024 renamed to dylib_rom_link
              added stdlib, stdio, unistd, dirent and sequencer methods
   02/29/2024 added generate_unix_path and generate_final_path
   03/01/2024 added memset, generate_unix_path, generate_final_path, file_is_valid_name
   03/07/2024 added spinner methods
   12/27/2024 removed file_atexit
   01/10/2025 added fwrite, fputs, fseek, ftell
   01/17/2025 added file_atexit
   01/18/2025 removed dir_init and file_init
   01/20/2025 added fputs, file_open_std_files, console_write_raw
   01/22/2025 performance improvements
   01/27/2025 removed file_open_std_files
   06/16/2025 mods for merging dylib and trampoline concepts
   06/24/2025 renamed file_is_valid_path to file_has_valid_dsr_name
   07/05/2025 dylib adjustments
   10/13/2025 removed uint2str
*/

#include <conversion.h>
#include <vdp.h>
#include <dylib.h>
#include <dylib_private.h>
#include <stdlib.h>
#include <stdlib_private.h>
#include <sequencer_private.h>
#include <stdio_private.h>
#include <dirent_private.h>
#include <unistd_private.h>
#include <spinner_private.h>
#include <unistd.h>
#include <console.h>

void dylib_rom1_link () {

   // FILE OPERATIONS

   dylib.fopen  = fopen;
   dylib.fread  = fread;
   dylib.fwrite = fwrite;
   dylib.fgets  = fgets;
   dylib.fputs  = fputs;
   dylib.fseek  = fseek;
   dylib.ftell  = ftell;
   dylib.fclose = fclose;

   // STRING OPERATIONS

   dylib.strlen  = strlen;
   dylib.strcpy  = strcpy;
   dylib.strcmp  = strcmp;
   dylib.strchr  = strchr;
   dylib.strcspn = strcspn;
   dylib.strcat  = strcat;
   dylib.memcpy  = memcpy;
   dylib.strtok  = strtok;

   // CONVERSION OPERATIONS
 
   dylib.int2str  = int2str;

   // STDLIB METHODS

   dylib.atexit  = atexit;
   dylib.k1_exit = kernel_exit;
   dylib._Exit   = _Exit;

   // UNISTD METHODS
   dylib.getcwd = getcwd;

   // INTERNAL METHODS

   dylib.atexit_init             = atexit_init;
   dylib.sequencer_init          = sequencer_init;
   dylib.proc_get_pid_path       = proc_get_pid_path;
   dylib.generate_unix_path      = generate_unix_path;
   dylib.generate_final_path     = generate_final_path;
   dylib.file_get_available      = file_get_available;
   dylib.file_atexit             = file_atexit;
   dylib.spinner_read            = spinner_read;
   dylib.spinner_write           = spinner_write;
   dylib.spinner_restore         = spinner_restore;
   dylib.dsrlnk                  = dsrlnk;
   dylib.reboot                  = reboot;
}
