/* kernel_console_display_flash.c
   This method flashes the display by reversing video and restoring it. In a text mode characters will invert, but in graphics I, only the border will flash.
   change history
   10/21/2025 initial version
   10/23/2025 moved to kernel
*/

#include <console.h>
#include <vdp.h>

void kernel_console_display_flash () {
   unsigned int bc = console_text_get_background_color ();
   unsigned int fc = console_text_get_foreground_color ();
   VDP_WAIT_VBLANK_CRU;
   VDP_WAIT_VBLANK_CRU;
   console_text_set_background_color (fc);
   console_text_set_foreground_color (bc);
   VDP_WAIT_VBLANK_CRU;
   console_text_set_background_color (bc);
   console_text_set_foreground_color (fc); 
}
