/* kernel_console_bitmap_draw_image.c
   This method draws an image stored in a sams cache at the specified origin. This method swaps out program ram
   while accessing the sams-based cache. The image can be drawn anywhere on the screen including partially or completely off-screen.
   change history
   01/25/2025 initial version
   01/26/2025 changed parameterization; complete re-write to all images to be displayed anywhere
   01/27/2025 minor performance improvements
   07/12/2025 updated to use new page restoration method
*/

#include <stdio.h>
#include <console.h>
#include <console_private.h>
#include <cache_private.h>
#include <vdp.h>
#include <string.h>
#include <sams_private.h>

void kernel_console_bitmap_draw_image (const char *cache_name, int y, int x) {

   sams_find_cache (cache_name);

   int *height             = (int *) 0xa000;
   int *width              = (int *) 0xa002;
   unsigned char *addr     = (unsigned char *) 0xa004;
   int yy;
   int xx;

   for (yy = y; yy < y + *height; yy++) {
      if (yy >= 0 && yy < cachex.console.screen_height) {
         for (xx = x; xx < x + *width; xx++) {
            if (xx >= 0 && xx < cachex.console.screen_width) {
               console_bitmap_set_pattern2 (yy, xx, addr, 8);
            }
            addr += 8;
         }
      } else {
         addr += *width << 3;
      }
   }

   for (yy = y; yy < y + *height; yy++) {
      if (yy >= 0 && yy < cachex.console.screen_height) {
         for (xx = x; xx < x + *width; xx++) {
            if (xx >= 0 && xx < cachex.console.screen_width) {
               console_bitmap_set_color_pattern2 (yy, xx, addr, 8);
            }
            addr += 8;
         }
      } else {
         addr += *width << 3;
      }
   }

   sams_restore_proc_pages ();
}
