/* kernel_console_bitmap_load_image.c
   This method loads an image into a sams cache. This method swaps out program ram while accessing the sams-based cache. off-screen.
   change history
   01/25/2025 initial version
   01/26/2025 changed parameterization; complete re-write to simpify the loading
   09/22/2025 added test for sams
*/

#include <stdio.h>
#include <console.h>
#include <cache_private.h>
#include <vdp.h>
#include <console_private.h>
#include <sams_private.h>
#include <string.h>
#include <cache_private.h>

int kernel_console_bitmap_load_image (const char *cache_name, const char *path) {
   int r = -1;

   if (cache.sams.page_count) {
      FILE *f = fopen (path, "rb");
      if (f) {
         sams_find_cache (cache_name);
         r = fread ((unsigned char *) 0xa000, 1, 24 * 1024, f);
         sams_restore_proc_pages ();
         fclose (f);
      }
   }

   return r;
}
