/* kernel_console_font_load.c
   This method loads fonts for the kernel.
   change log:
   01/17/2025 initial version
   02/19/2025 added initialization of the char defs for 0-31 as the display at boot is initialized to displaying
              char 0 on the whole screen and 0 is part of the TI logo.
   05/28/2025 moved the bar symbol one pixel row higher
*/

#include <console_private.h>
#include <vdp.h>

void kernel_console_font_load () {
   const unsigned char font_bitmap[] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 
      0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x28, 0x28, 0x7C, 0x28, 0x7C, 0x28, 0x28, 0x00, 
      0x38, 0x54, 0x50, 0x38, 0x14, 0x54, 0x38, 0x00, 
      0x60, 0x64, 0x08, 0x10, 0x20, 0x4C, 0x0C, 0x00, 
      0x20, 0x50, 0x50, 0x20, 0x54, 0x48, 0x34, 0x00, 
      0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x08, 0x10, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00, 
      0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00, 
      0x00, 0x28, 0x10, 0x7C, 0x10, 0x28, 0x00, 0x00, 
      0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x20, 
      0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 
      0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 
      0x38, 0x44, 0x4C, 0x54, 0x64, 0x44, 0x38, 0x00, 
      0x10, 0x30, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 
      0x38, 0x44, 0x04, 0x08, 0x10, 0x20, 0x7C, 0x00, 
      0x38, 0x44, 0x04, 0x18, 0x04, 0x44, 0x38, 0x00, 
      0x08, 0x18, 0x28, 0x48, 0x7C, 0x08, 0x08, 0x00, 
      0x7C, 0x40, 0x78, 0x04, 0x04, 0x44, 0x38, 0x00, 
      0x18, 0x20, 0x40, 0x78, 0x44, 0x44, 0x38, 0x00, 
      0x7C, 0x04, 0x08, 0x10, 0x20, 0x20, 0x20, 0x00, 
      0x38, 0x44, 0x44, 0x38, 0x44, 0x44, 0x38, 0x00, 
      0x38, 0x44, 0x44, 0x3C, 0x04, 0x08, 0x30, 0x00, 
      0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, 
      0x00, 0x30, 0x30, 0x00, 0x30, 0x10, 0x20, 0x00, 
      0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x00, 
      0x00, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00, 0x00, 
      0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 
      0x38, 0x44, 0x04, 0x08, 0x10, 0x00, 0x10, 0x00, 
      0x38, 0x44, 0x5C, 0x54, 0x5C, 0x40, 0x38, 0x00, 
      0x38, 0x44, 0x44, 0x7C, 0x44, 0x44, 0x44, 0x00, 
      0x78, 0x24, 0x24, 0x38, 0x24, 0x24, 0x78, 0x00, 
      0x38, 0x44, 0x40, 0x40, 0x40, 0x44, 0x38, 0x00, 
      0x78, 0x24, 0x24, 0x24, 0x24, 0x24, 0x78, 0x00, 
      0x7C, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7C, 0x00, 
      0x7C, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x00, 
      0x3C, 0x40, 0x40, 0x5C, 0x44, 0x44, 0x38, 0x00, 
      0x44, 0x44, 0x44, 0x7C, 0x44, 0x44, 0x44, 0x00, 
      0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 
      0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x38, 0x00, 
      0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0x00, 
      0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7C, 0x00, 
      0x44, 0x6C, 0x54, 0x54, 0x44, 0x44, 0x44, 0x00, 
      0x44, 0x64, 0x64, 0x54, 0x4C, 0x4C, 0x44, 0x00, 
      0x38, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 
      0x78, 0x44, 0x44, 0x78, 0x40, 0x40, 0x40, 0x00, 
      0x38, 0x44, 0x44, 0x44, 0x54, 0x48, 0x34, 0x00, 
      0x78, 0x44, 0x44, 0x78, 0x50, 0x48, 0x44, 0x00, 
      0x38, 0x44, 0x40, 0x38, 0x04, 0x44, 0x38, 0x00, 
      0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 
      0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, 
      0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 
      0x44, 0x44, 0x44, 0x54, 0x54, 0x54, 0x28, 0x00, 
      0x44, 0x44, 0x28, 0x10, 0x28, 0x44, 0x44, 0x00, 
      0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00, 
      0x7C, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7C, 0x00, 
      0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38, 0x00, 
      0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 
      0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00, 
      0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 
      0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x38, 0x04, 0x3C, 0x44, 0x3C, 0x00, 
      0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x78, 0x00, 
      0x00, 0x00, 0x38, 0x44, 0x40, 0x40, 0x38, 0x00, 
      0x04, 0x04, 0x3C, 0x44, 0x44, 0x44, 0x3C, 0x00, 
      0x00, 0x00, 0x38, 0x44, 0x7C, 0x40, 0x38, 0x00, 
      0x0C, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x00, 
      0x00, 0x00, 0x3C, 0x44, 0x44, 0x3C, 0x04, 0x38, 
      0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x44, 0x00, 
      0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 
      0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x48, 0x30, 
      0x40, 0x40, 0x44, 0x48, 0x70, 0x48, 0x44, 0x00, 
      0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 
      0x00, 0x00, 0x68, 0x54, 0x54, 0x54, 0x54, 0x00, 
      0x00, 0x00, 0x58, 0x64, 0x44, 0x44, 0x44, 0x00, 
      0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 
      0x00, 0x00, 0x78, 0x44, 0x44, 0x44, 0x78, 0x40, 
      0x00, 0x00, 0x3C, 0x44, 0x44, 0x44, 0x3C, 0x04, 
      0x00, 0x00, 0x28, 0x34, 0x20, 0x20, 0x20, 0x00, 
      0x00, 0x00, 0x3C, 0x40, 0x38, 0x04, 0x78, 0x00, 
      0x00, 0x10, 0x38, 0x10, 0x10, 0x10, 0x0C, 0x00, 
      0x00, 0x00, 0x44, 0x44, 0x44, 0x4C, 0x34, 0x00, 
      0x00, 0x00, 0x44, 0x44, 0x44, 0x28, 0x10, 0x00, 
      0x00, 0x00, 0x54, 0x54, 0x54, 0x54, 0x28, 0x00, 
      0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 
      0x00, 0x00, 0x44, 0x44, 0x44, 0x3C, 0x04, 0x38, 
      0x00, 0x00, 0x7C, 0x08, 0x10, 0x20, 0x7C, 0x00, 
      0x00, 0x0C, 0x10, 0x10, 0x20, 0x10, 0x10, 0x0C, 
      0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00,
      0x00, 0x60, 0x10, 0x10, 0x08, 0x10, 0x10, 0x60, 
      0x00, 0x00, 0x20, 0x54, 0x08, 0x00, 0x00, 0x00
   };

   // clear char defs for 0x00 - 0x19
   vdpmemset (0x0800, 0x00, 0x0100);

   // 0x0800 base and then 0x20 * 0x8 to get to the space address
   vdpmemcpy (0x0900, font_bitmap, sizeof (font_bitmap));
}
