/* kernel_sams_get_region_info.c
   This method returns the named region info.
   change history
   07/08/2025 initial version
   07/14/2025 added age
*/

#include <sams_private.h>
#include <cache_private.h>
#include <string.h>

void kernel_sams_get_region_info (int region, char *name, int *age) {

   int cache_info_region = (cache.sams.page_count - 16) / 6 - 1;   // 41 if this is a 1 MB SAMS card
   sams_map_region (cache_info_region);

   sams_cache_t * sams_cache = (sams_cache_t *) 0xa000;            // generate a cache structure pointer
   strcpy (name, sams_cache->filename[region]);
   *age = sams_cache->age[region];

   sams_restore_proc_pages ();
} 
