/* kernel_shmat.c
   This method attaches a shared memory segment to program memory.
   change history 
   07/12/2025 initial version
*/

#include <sys/shm.h>
#include <sams_private.h>
#include <cache_private.h>

void *kernel_shmat (int shmid, const void *shmaddr, int shmflg, int page) {
   void *addr = (void *) -1;

   int region_index = page / 6;
   int page_index = page % 6;
   if (cache.shm.entry[shmid].region[region_index] >= 0) {                     // verify region is allocated
      cache.sams.proc_page[5] = sams_region_to_page (cache.shm.entry[shmid].region[region_index]) + page_index;
      sams_restore_proc_pages ();
      addr = (char *) 0xf000;
   }

   return addr;
}
