/* kernel_shmctl.c
   This method controls a shared memory segment. 
   change history
   07/12/2025 initial version
   07/14/2025 updated to call sams_expire_region
*/

#include <cache_private.h>
#include <string.h>
#include <sams_private.h>
#include <conversion.h>
#include <sys/shm.h>
#include <vdp.h>

int kernel_shmctl (int shmid, int cmd, struct shmid_ds *buf) {
 
   int r = -1;

   if (cache.shm.entry[shmid].in_use) {
      if (cmd | IPC_RMID) {

         int s = 0;
         for (int rid = 0; rid < SHM_REGION_MAX; rid++) {
            if (cache.shm.entry[shmid].region[rid] != -1) {
               s += sams_expire_region (cache.shm.entry[shmid].region[rid]);
            }
         }

         cache.shm.entry[shmid].key    = 0;
         cache.shm.entry[shmid].in_use = false;

         if (!s) {
            r = 0;
         }
      }
   }

   return r;
}
