/* kernel_shmdt.c
   This method detaches a shared memory segment from program memory. 
   change history
   07/12/2025 initial version
*/

#include <cache_private.h>
#include <sams_private.h>
#include <sys/shm.h>

int kernel_shmdt (const void *shmaddr) {
   int r = -1;

   unsigned int page_index = ((unsigned int) shmaddr >> 12) - 0x000a; // calculate the page index
   if (cache.sams.proc_page[page_index] != (cache.sams.proc_page[0] + page_index)) {
      cache.sams.proc_page[page_index] = cache.sams.proc_page[0] + page_index;
      sams_restore_proc_pages ();
      r = 0;
   }

   return r;
}
