/* console_bitmap_load_image.c
   This method calls the kernel method which will likely page swap the program ram.
   change history
   01/25/2025 initial version
   01/26/2025 changed parameterization
   06/16/2025 updates for merging dylib and trampolines
*/

#include <console.h>
#include <rom_private.h>
// #include <kernel_private.h>
#include <dylib.h>

int console_bitmap_load_image (const char *cache_name, const char *path) {
   int r;
   BSWITCH_2 = 1;
   r = dylib.k2_console_bitmap_load_image (cache_name, path);
   ROM_PAGE_SET_STANDARD = 1;
   return r;
}
