/* shmat.c
   This method attaches a shared memory segment to program memory. It is an intermediary method (trampoline).
   change history 
   07/12/2025 initial version
*/

#include <sys/shm.h>
#include <rom_private.h>
#include <dylib.h>

void *shmat (int shmid, const void *shmaddr, int shmflg, int page) {
   BSWITCH_3 = 1;
   void *r = dylib.k3_shmat (shmid, shmaddr, shmflg, page);
   ROM_PAGE_SET_STANDARD = 1;
   return r;
}
