/* shmctl.c
   This method is used to control shared memory segment. It is an intermediary method (trampoline).
   change history 
   07/12/2025 initial version
*/

#include <sys/shm.h>
#include <rom_private.h>
#include <dylib.h>

int shmctl (int shmid, int cmd, struct shmid_ds *buf) {
   BSWITCH_3 = 1;
   int r = dylib.k3_shmctl (shmid, cmd, buf);
   ROM_PAGE_SET_STANDARD = 1;
   return r;
}
