/* shmdt.c
   This method detaches a shared memory segment from program memory. It is an intermediary method (trampoline).
   change history 
   07/12/2025 initial version
*/

#include <sys/shm.h>
#include <rom_private.h>
#include <dylib.h>

int shmdt (const void *shmaddr) {
   BSWITCH_3 = 1;
   int r = dylib.k3_shmdt (shmaddr);
   ROM_PAGE_SET_STANDARD = 1;
   return r;
}
