/* login.c
   This program provides a login facility for UNIX99.
   change log:
   11/10/2023 initial version
   11/11/2023 updated to use ciphers
   11/12/2023 updated to use get_passwd_file_path
   11/16/2023 updated to use image package
   11/21/2023 updated to use getpass
   11/23/2023 updated to handle case where username entered is blank
   12/10/2023 removed reference to string_ext.h
   02/11/2024 added van electronics logo
   02/27/2024 added use of dylib
   12/26/2024 removed printing of the unix99 logo
   01/20/2025 updated fputs to dylib
   06/08/2025 updated to handle \n returned by fgets
   06/09/2025 handle ctrl-d
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <unistd_private.h>
#include <dylib.h>
#include <stdbool.h>
#include <signal.h>

// the login program
int main (int argc, char *argv[]) {

   if (getuid () == 0) {                                       // ensure the user is root

      char username[10];                                       // username
      char *password;                                          // password

      if (argc == 2) {                                         // capture the username if already provided as a parameter
         dylib.strcpy (username, argv[1]);
      } else {
         dylib.strcpy (username, "");
      }
 
      signal (SIGINT, SIG_IGN);

      while (1) {                                              // loop until successful login
         if (!dylib.strlen (username)) {                       // if a username wasn't provided...
            bool repeat = true;
            while (repeat) {
               dylib.fputs ("login: ", stdout);                   // prompt for the user name
               if (dylib.fgets (username, 9, stdin) && dylib.strlen (username))  {         // get the user name
                  username[dylib.strcspn (username, "\r\n")] = 0x00;
                  repeat = false;
               } else {
                  dylib.fputs ("\n", stdout);
               }
            }
         }
         if (dylib.strlen (username)) {                        // only request a password if there's a username
            password = getpass ("password: ");                 // prompt the user for the password and get it
            if (passwd_login_is_valid (username, password)) {  // test for a valid username/password combo
               setlogin (username);                            // login the valid user
               break;
            } else {
               dylib.strcpy (username, "");                    // clear the user name
               dylib.fputs ("Login incorrect\n", stderr);      // indicate login failure
            }
         }
      } 
   } else {
      dylib.fputs ("login can only be run by root\n", stderr); // write error only root can run login
   }

   return 0;                                                   // return success
}
