/* long.c
   This method tests printing of long and unsigned long types with fprintf.
   change log:
   11/22/2023 initial version
*/

#include <stdio.h>
#include <dylib.h>

int main (int argc, char *argv[]) {

   dylib.fputs ("long:\n", stdout);
   for (long l = 0; l <= (long) 32 * (long) 1024; l += 16) {
      fprintf (stdout, "\r%4ld", l);
   }
   dylib.fputs ("\n", stdout);

   dylib.fputs ("unsigned long:\n", stdout);
   for (unsigned long ul = (unsigned long) 32 * (unsigned long) 1024 + (unsigned long) 16; 
        ul <= (unsigned long) 64 * (unsigned long) 1024; 
        ul += 16) {
      fprintf (stdout, "\r%4lu", ul);
   }
   dylib.fputs ("\n", stdout);

   dylib.fputs ("shifting unsigned long\n", stdout);
   unsigned long v;
   for (int s = 0; s <= 30; s++) {
      v = (unsigned long) 1 << s;
      fprintf (stdout, "1 << %d = %lu\n", s, v);
   }
   dylib.fputs ("\n", stdout);

   long la = 2007;
   long ld, lm;

   dylib.fputs ("long div mod\n", stdout);

   for (long lb = 1; lb < 10; lb++) {
      ld = la / lb;
      lm = la % lb;
      fprintf (stdout, "%ld / %ld = %ld m %ld\n", la, lb, ld, lm);
   }

   unsigned long ula = 3008;
   unsigned long uld, ulm;

   for (unsigned long ulb = 1; ulb < 10; ulb++) {
      uld = ula / ulb;
      ulm = ula % ulb;
      fprintf (stdout, "%lu / %lu = %lu m %lu\n", ula, ulb, uld, ulm);
   }

   return 0;
}
