/* longtest.c
   This program tests long type operations.
   change log:
   01/20/2025 added header
              updated fputs to dylib
*/


#include <stdio.h>
#include <conversion.h>
#include <longdivmod.h>
#include <ulongdivmod.h>
#include <dylib.h>

void show_unsigned_long_div_mod (unsigned long i, unsigned long j) {
   unsigned long q, r;
   q = __udivdi3 (i, j);
   r = __umoddi3 (i, j);
   dylib.fputs (ultoa (i), stdout);
   dylib.fputs (" / ", stdout);
   dylib.fputs (ultoa (j), stdout);
   dylib.fputs (" = ", stdout);
   dylib.fputs (ultoa (q), stdout);
   dylib.fputs (" r ", stdout);
   dylib.fputs (ultoa (r), stdout);
   dylib.fputs ("\n", stdout);
}

void unsigned_long_test_do () {
   unsigned long i, j;
   for (i = 32; i >= 1; i--) {
      for (j = 32; j >= 1; j--) {
         show_unsigned_long_div_mod (i, j);
      }
   }

   show_unsigned_long_div_mod (0x40000000, 0x20000000);
   show_unsigned_long_div_mod (0x80000000, 0x20000000);
   show_unsigned_long_div_mod (0x80000000, 0xc0000000);
   show_unsigned_long_div_mod (0xffffffff, 0x00000001);
   show_unsigned_long_div_mod (0xffffffff, 0xffffffff);
   show_unsigned_long_div_mod (0x00000000, 0xffffffff);
   show_unsigned_long_div_mod (0xc0000000, 0x20000000);
   show_unsigned_long_div_mod (0xc0000000, 0xc0000000);
   show_unsigned_long_div_mod (0x00000000, 0x00000001);
   show_unsigned_long_div_mod (0x00000000, 0x00000002);
   show_unsigned_long_div_mod (0x00000000, 0x00000004);
   show_unsigned_long_div_mod (0x00000000, 0x00000008);
}

void show_long_div_mod (long i, long j) {
   long q, r;
   q = __divdi3 (i, j);
   r = __moddi3 (i, j);
   dylib.fputs (ltoa (i), stdout);
   dylib.fputs (" / ", stdout);
   dylib.fputs (ltoa (j), stdout);
   dylib.fputs (" = ", stdout);
   dylib.fputs (ltoa (q), stdout);
   dylib.fputs (" r ", stdout);
   dylib.fputs (ltoa (r), stdout);
   dylib.fputs ("\n", stdout);
}

void long_test_do () {
   long i, j;
   for (i = 32; i >= 0; i--) {
      for (j = 32; j >= 1; j--) {
         show_long_div_mod (i, j);
      }
   }

   show_long_div_mod (0x40000000, 0x20000000);
   show_long_div_mod (0xc0000000, 0x20000000);
   show_long_div_mod (0xc0000000, 0xc0000000);
}

int main (int argc, char *argv[]) {

   dylib.fputs ("long div mod tests\n", stdout);

   long_test_do ();
   unsigned_long_test_do ();

   return 0;
}
