/* malloc.c
   This method tests the dynamic memory management functions.
   change log:
   06/23/2023 initial version
   11/23/2023 updated to output the unit and total allocation size
   01/20/2025 moved fputs to dylib
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <dylib.h>

#define TEST_SIZE 122

int main (int argc, char *argv[]) {

   char *s[1000];
   int count = 0;
   int i, j;
   char *p;

   dylib.fputs ("test malloc\n\n", stdout);

   dylib.fputs ("malloc'd addresses: ", stdout);
   while ((s[count] = malloc (TEST_SIZE)) != NULL) {
      fprintf (stdout, "%x ", (unsigned int) s[count]);
      count++;
   }
   dylib.fputs ("\n\n", stdout);
   fprintf (stdout, "allocations: %d\nsize: %d bytes\ntotal allocated: %d bytes\n", count, TEST_SIZE, TEST_SIZE * count);

   dylib.fputs ("\nwrite...", stdout);
   for (i = 0; i < count; i++) {
      p = s[i];
      for (j = 0; j < TEST_SIZE; j++) {
         *p = (char) i;
         p++;
      }
   }
   dylib.fputs ("done\n", stdout);

   dylib.fputs ("read...", stdout);
   for (i = 0; i < count; i++) {
      p = s[i];
      for (j = 0; j < TEST_SIZE; j++) {
         assert (*p == (char) i);
         p++;
      }
   }
   dylib.fputs ("done\n", stdout);

   dylib.fputs ("deleting...", stdout);
   for (i = 0; i < count; i+= 2) {
      free (s[i]);
      s[i] = 0x0000;
   }
   dylib.fputs ("done\n", stdout);

   dylib.fputs ("reallocating and writing...", stdout);
   for (i = 0; i < count; i+= 2) {
      s[i] = malloc (TEST_SIZE);
      assert (s[i]);
      p = s[i];
      for (j = 0; j < TEST_SIZE; j++) {
         *p = (char) i;
         p++;
      }
   }
   dylib.fputs ("done\n", stdout);

   dylib.fputs ("read again...", stdout);
   for (i = 0; i < count; i++) {
      p = s[i];
      for (j = 0; j < TEST_SIZE; j++) {
         assert (*p == (char) i);
         p++;
      }
   }
   dylib.fputs ("done\n", stdout);

   dylib.fputs ("write backwards...", stdout);
   for (i = count - 1; i >=0; i--) {
      p = s[i];
      for (j = 0; j < TEST_SIZE; j++) {
         *p = (char) i;
         p++;
      }
   }
   dylib.fputs ("done\n", stdout);

   dylib.fputs ("read yet again...", stdout);
   for (i = 0; i < count; i++) {
      p = s[i];
      for (j = 0; j < TEST_SIZE; j++) {
         assert (*p == (char) i);
         p++;
      }
   }
   dylib.fputs ("done\n", stdout);

   return 0;
}
