/* man.c
   This file implemented the manual page command.
   change log
   07/23/2025 initial version
   08/17/2025 removed temp file
   09/29/2025 added test for whether stdout points to a terminal or not, use more or stream output
   10/04/2025 updated to use dylib
*/

#include <groff.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <dylib.h>
#include <util.h>
#include <unistd.h>
#include <stdlib.h>

int main (int argc, char *argv[]) {

   const char *formatted_page_path = "/tmp/t_man";

   if (argc == 2) {
      char manual_page_path[FILENAME_MAX];
      dylib.strcpy (manual_page_path, "/usr/share/man/");
      dylib.strcat (manual_page_path, argv[1]);
   
      FILE *fin = dylib.fopen (manual_page_path, "rb");
      if (fin) {
         struct winsize w;
         int istty = isatty (fileno (stdout));
         FILE *fout;
         if (istty) {
            ioctl (fileno (stdout), TIOCGWINSZ, &w);                    // get the size of the screen window
            fout = dylib.fopen (formatted_page_path, "w");              // create a temporary output file
         } else {
            w.ws_row = 60;                                              // default to a page size
            w.ws_col = 80;
            fout = stdout;                                              // use stdout directly
         }
         groff (fin, fout, w.ws_row, w.ws_col);
         dylib.fclose (fin);
         if (istty) {
            dylib.fclose (fout);                                        // close the temporary file
            more (formatted_page_path, true);                           // write the temp file to stdout via more
            remove (formatted_page_path);                               // remove the temporary file
         }
      } else {
         dylib.fputs ("No manual entry for ", stderr);
         dylib.fputs (argv[1], stderr);
         dylib.fputs ("\n", stderr);
      }
   }

   return 0;
}
