dim restore_mode as integer
dim restore_rows as integer
dim restore_cols as integer

dim level as integer

dim player_ship_y as integer
dim player_ship_x as integer
dim player_ship_vy as integer
dim player_ship_vx as integer

dim player_bullet_y(4) as integer
dim player_bullet_x(4) as integer
dim player_bullet_vy(4) as integer
dim player_bullet_vx(4) as integer
dim player_bullet_index(4) as integer
dim player_bullet_inuse(4) as integer

dim enemy_ship_y as integer
dim enemy_ship_x as integer
dim enemy_ship_vy as integer
dim enemy_ship_vy as integer
dim enemy_ship_inuse as integer

dim enemy_bullet_y as integer
dim enemy_bullet_x as integer
dim enemy_bullet_vy as integer
dim enemy_bullet_vx as integer
dim enemy_bullet_inuse as integer

dim meteor_y(25) as integer
dim meteor_x(25) as integer
dim meteor_vy(25) as integer
dim meteor_vx(25) as integer
dim meteor_inuse(25) as integer

sub draw_all ()
   dim i as integer
   dim s as integer

   call sprite (0, 16, 15, player_ship_y, player_ship_x, 0, 0)

   s = 1
   for i = 0 to 3
      if player_bullet_inuse(i) > 0 then
         call sprite (s, player_bullet_index(i), 15, player_bullet_y(i), player_bullet_x(i), 0, 0)
         player_bullet_index(i) = player_bullet_index(i) + 1
         if player_bullet_index(i) > 20 then
            player_bullet_index(i) = 17
         end if
      else
         call sprite (s, 17, 15, 192, 0, 0, 0)
      end if
      s = s + 1
   next i

   if enemy_ship_inuse > 0 then
      call sprite (5, 33, 15, player_ship_y, player_ship_x, 0, 0)
   end if

   if enemy_bullet_inuse > 0 then
      call sprite (6, 33, 15, enemy_bullet_y, enemy_bullet_x, 0, 0)
   end if

   s = 7
   for i = 0 to 24
      if meteor_inuse(i) > 0 then
         call sprite (s, 24, 15, meteor_y(i), meteor_x(i), 0, 0)
      else
         call sprite (s, 24, 15, 192, 0, 0, 0)
      end if
      s = s + 1
   next i

end sub

sub process_input ()
   dim y as integer
   dim x as integer

   call joyst (0, y, x)

   player_ship_vy = player_ship_vy + y / 4
   player_ship_vx = player_ship_vx + x / 4

   if player_ship_vy < -4 then
      player_ship_vy = -4
   else
      if player_ship_vy > 4 then
         player_ship_vy = 4
      end if
   end if

   if player_ship_vx < -4 then
      player_ship_vx = -4
   else
      if player_ship_vx > 4 then
         player_ship_vx = 4
      end if
   end if

   if inkey() = 90 then
      dim i as integer
      for i = 0 to 3
         if player_bullet_inuse(i) = 0 then
            player_bullet_y(i) = player_ship_y
            player_bullet_x(i) = player_ship_x + 4
            player_bullet_vy(i) = player_ship_vy
            player_bullet_vx(i) = player_ship_vx + 4
            player_bullet_index(i) = 17
            player_bullet_inuse (i) = 1
            break
         end if
      next i
   end if

end sub

sub meteor_generate ()

   if RNDI (192) < level then
      dim i as integer

      for i = 0 to 24
         if meteor_inuse(i) = 0 then
            meteor_y(i) = rndi (192)
            meteor_x(i) = 255
            meteor_vy(i) = 0
            meteor_vx(i) = -1 - RNDI(2)
            meteor_inuse(i) = 1
            break
         end if
      next i
   end if

end sub

sub handle_player_bullets ()
   dim i as integer
   dim j as integer
   dim sb as integer
   dim sm as integer
   dim did_coincide as integer

   sb = 1
   for i = 0 to 3
      if player_bullet_inuse(i) <> 0 then
         sm = 7
         for j = 0 to 24
            if meteor_inuse(j) <> 0 then
               call coinc (sb, sm, 8, did_coincide)
               if did_coincide <> 0 then
                  meteor_inuse(j) = 0
                  player_bullet_inuse(i) = 0
               end if
            end if
            sm = sm + 1
         next j
      end if
      sb = sb + 1
   next i

end sub

sub move_all ()
   player_ship_y = player_ship_y + player_ship_vy
   player_ship_x = player_ship_x + player_ship_vx

   if player_ship_y < 0 then
      player_ship_y = 0
      player_ship_vy = 0
   else
      if player_ship_y > 183 then
         player_ship_y = 183
         player_ship_vy = 0
      end if
   end if

   if player_ship_x < 0 then
      player_ship_x = 0
      player_ship_vx = 0
   else
      if player_ship_x > 80 then
         player_ship_x = 80
         player_ship_vx = 0
      end if
   end if

   dim i as integer

   for i = 0 to 3
      if player_bullet_inuse(i) > 0 then
         player_bullet_y(i) = player_bullet_y(i) + player_bullet_vy(i)  
         player_bullet_x(i) = player_bullet_x(i) + player_bullet_vx(i)  
         if player_bullet_y(i) < 0 then
            player_bullet_inuse(i) = 0
         else 
            if player_bullet_y(i) > 191 then
               player_bullet_inuse(i) = 0
            end if
         end if
         if player_bullet_x(i) > 255 then
            player_bullet_inuse(i) = 0
         end if
      end if
   next i

   for i = 0 to 24
      if meteor_inuse(i) > 0 then
         meteor_y(i) = meteor_y(i) + meteor_vy(i)
         meteor_x(i) = meteor_x(i) + meteor_vx(i)
         if meteor_y(i) < 0 then
            meteor_inuse(i) = 0
         else
            if meteor_y(i) > 191 then
               meteor_inuse(i) = 0
            end if
         end if
         if meteor_x(i) < 0 then
            meteor_inuse(i) = 0
         end if
      end if
   next i

end sub

sub init_vals ()

   dim i as integer

   player_ship_y = 92
   player_ship_x = 40
   player_ship_vy = 0
   player_ship_vx = 0
   for i = 0 to 3
      player_bullet_inuse(i) = 0
   next i

   enemy_ship_inuse = 0
   enemy_bullet_inuse = 0

   for i = 0 to 24
      meteor_inuse(i) = 0
   next i

end sub

sub display_setup ()
   call display_mode_get (restore_mode)
   call display_rows_and_cols (restore_rows, restore_cols)
 
   call display_mode (0, 24) 

   call char (16, "E0703C7E7F3870E0")
   call char (17, "001010FE10100000")
   call char (18, "0204281028408000")
   call char (19, "1010103810101000")
   call char (20, "8040281028040200")
   call char (24, "1C1EFFFFFFFF7E3C")
end sub

sub bmain ()

   call display_setup ()

   call clear ()
   display at (0, 0): "Meteors!"

   level = 500
   call init_vals (level)

   do
      call process_input ()
      call meteor_generate ()
      call handle_player_bullets ()
      call move_all ()
      call draw_all ()
   loop

end sub
