/* mkdir.c
   This program makes directories.
   change log:
   05/24/2025 initial version
   05/29/2025 added error case for operation not supported
   07/05/2025 added printing of usage when no files specified
*/

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dylib.h>

void print_error (int code, const char *name) {
   dylib.fputs ("mkdir: ", stderr);
   dylib.fputs (name, stderr);
   switch (code) {
      case 1:
         dylib.fputs (": No such file or directory\n", stderr);
         break;
      case 2:
         dylib.fputs (": File exists\n", stderr);
         break;
      case 3:
         dylib.fputs (": Operation not supported\n", stderr);
         break;
      default:
         dylib.fputs (": unhandled error\n", stderr);
         break;
   }
}

void print_usage () {
   dylib.fputs ("usage: mkdir -v dir [...]\n", stderr);
}

int main (int argc, char *argv[]) {

   int r = 0;
   int r2;

   bool verbose = false;
   bool error   = false;

   // capture the options
   int opt;
   while ((opt = getopt (argc, argv, "v")) != -1) {
      switch (opt) {
         case 'v':
            verbose = true;
            break; 
         case '?':
         default:
            error = true;       
            break;
      }
   }

   // adjust argc and argv removing the processed options
   argc -= optind;
   argv += optind;

   if (error || !argc) {
      print_usage ();
      r = 1;
   } else {
      for (int i = 0; i < argc; i++) {
         r2 = mkdir (argv[i], 0);
         if (r2) {
            print_error (r2, argv[i]);
            r += r2;
         } else {
            if (verbose) {
               dylib.fputs (argv[i], stdout);
               dylib.fputs ("\n", stdout);
            }
         }
      }
   }

   return r;
}
