/* more.c
   This program displays text a page at a time.
   change log:
   06/23/2023 initial version
   06/08/2025 added use of getopt
   06/09/2025 corrected reading of stdin when piped
   06/11/2025 updated more to handle ctrl-c
              added print_over option
*/

#include <stdio.h>
#include <stdio_private.h>
#include <util.h>
#include <unistd.h>
#include <dylib.h>

void display_usage () {                                          // display usage information
   dylib.fputs ("usage: more [-p] file [...]\n", stderr);
}

int main (int argc, char *argv[]) {                              // the main procedure

   bool print_over = false;                                      // print_over flag

   // capture the options
   int error = false;
   int opt;
   while ((opt = getopt (argc, argv, "p")) != -1) {              // capture options
      switch (opt) {
         case 'p':                                               // handle print_over option
            print_over = true;
            break;
         case '?':                                               // error/default case
         default:
            error = true;
            break;
      }
   }

   if (!error) {                                                 // process parameters

      argc -= optind;                                            // adjust argc and argv removing the processed options
      argv += optind;

      if (argc) {                                                // handle file list
         for (int i = 0; i < argc; i++) {                        // loop through all files
            more (argv[i], print_over);                          // more from file
         }
      } else {                                                   // handle stdin
         if (stdin->ftype == FTYPE_CONSOLE_IN) {                 // disallow console as an input
            dylib.fputs ("Missing filename\n", stderr);
         } else {                                                // allow input via stdin from a pipe
            more (NULL, print_over);                             // more from stdin
         }
      }
   } else {
      display_usage ();                                          // display usage
   }

   return 0;                                                     // return a result 
                                                                 // to-do: return a result that indicates if an error ocurred
}
