/* mouse.c
   This program implements a lower-level mouse and keyboard read test.
   change history
   04/16/2025 initial version
   04/18/2025 removed call for mouse_update that is now integrated into mouse_get
   04/24/2025 changed keyboard.h to private
              updated to center mouse
   05/03/2025 cleanup
   05/15/2025 removed keyboard test code
*/

#include <stdio.h>
#include <console.h>
#include <mouse.h>
#include <cache_private.h>

void test_mouse () {

   int k;
   unsigned int y;
   unsigned int x;
   bool bleft;
   bool bmiddle;
   bool bright;
   char s[64];

   fprintf (stdout, "\n\n\n\n");

   mouse_center ();

   while (1) {
      k = console_get_key ();
      if (k == 'x' || k == 'X') {
         break;
      }

      mouse_get (&y, &x, &bleft, &bmiddle, &bright);
  
      sprintf (s, "y[%u] x[%u] [%d] [%d] [%d]   ", y, x, bleft, bmiddle, bright);

      console_write_raw (22, 0, s, 30);
   }
}
int main (int argc, char *argv[]) {

   const int mouse_available = cachex.have_external_mouse;

   fprintf (stdout, "mouse is available? %d\n", mouse_available);

   if (mouse_available) {
      test_mouse ();
   }

   return 0;
}
