/* ms_drv.c
   This program sets the mouse status, based on the request and availability of a mouse. Requires TIPI and an attached mouse to
   activate.
   change history
   06/14/2025 initial version
   06/16/2025 updated exit reference
*/

#include <stdio.h>
#include <cache_private.h>
#include <mouse_private.h>
#include <dylib.h>
#include <unistd.h>
#include <stdlib.h>

void display_usage () {
   dylib.fputs ("usage: ms_drv [-d] [-e]\n", stderr);
}

int main (int argc, char *argv[]) {

   bool enable = true;

   // capture the options
   int opt;
   int error = false;
   while ((opt = getopt (argc, argv, "de")) != -1) {
      switch (opt) {
         case 'd':
            enable = false;
            break;
         case 'e':
            enable = true;
            break;
         case '?':
         default:
            error = true;
            break;
      }
   }

   if (error) {
      display_usage ();
      exit (1);
   }

   // adjust argc and argv removing the processed options
   argc -= optind;
   argv += optind;

   cachex.have_external_mouse = enable && !mouse_init ();

   return 0;
}
