/* pi.c
   Dik T. Winter wrote a 160-byte C program to compute the first 800 digits of pi. 
   The original code is:

   int a=10000,b,c=2800,d,e,f[2801],g;main(){for(;b-c;)f[b++]=a/5;
   for(;d=0,g=c*2;c-=14,printf("%.4d",e+d/a),e=d%a)for(b=c;d+=f[b]*a,
   f[b]=d%--g,d/=g--,--b;d*=b);}

   This program is an adaptation of that program for the TI-99/4a. https://crypto.stanford.edu/pbc/notes/pi/code.html
   provides further explanation. The primary change is migration of integers to longs. TI's integers are 16 bit and the
   values generated exceed the storable values. Unfortunately the use of long values greatly slows the code since long
   processing is implemented solely in software.

   limitations

   None

   change history
   09/01/2025 initial version
   09/02/2025 updated sprintf format that was skipping printing leading zeros
*/

#include <stdlib.h>
#include <stdio.h>

int main() {

   int *r = malloc (sizeof (long) * 2801);
   int i, k;
   long b, d;
   long c = 0;
   int first = 1;
   char *p;
   char s[8];

   for (i = 0; i < 2800; i++) {
      r[i] = 2000;
   }
   r[2800] = 0;

   for (k = 2800; k > 0; k -= 14) {
      d = 0;

      i = k;
      while (1) {
         d = d + (long) ((long) r[i] * (long) 10000);
         b = 2 * i - 1;

         r[i] = (long) d % (long) b;
         d = (long) d / (long) b;
         i--;
         if (!i) {
            break;
         }
         d *= i;
      }

      sprintf (s, "%04ld", c + d / 10000);

      if (first) {
         fprintf (stdout, "%c.", s[0]);
         p = s + 1;
         fprintf (stdout, "%s", p);
         first = 0;
      } else {
         fprintf (stdout, "%s", s);
      }

      c = (long) d % (long) 10000;
   }

   fprintf (stdout, "\n");

   return 0;
}
