/* pio.c
   This program demonstrates the use of the parallel port. Note that I do not have a TI-99 with a parallel port nor a parallel
   device.
   change log:
   12/22/2023 initial version
   03/01/2024 updated to use dylib
   01/11/2025 changed FILE pf to f
   01/20/2025 moved fputs to dylib
   05/03/2025 updated for location of PIO file
*/

#include <stdio.h>
#include <printer_private.h>
#include <assert.h>
#include <conversion.h>
#include <dylib.h>

const char *msg_print_start = "Printing to the parallel\n";
const char *msg_hello       = "Hello PIO!\n";
const char *cr              = "\n";

int main (int argc, char *argv[]) {

   int r;

   dylib.fputs (msg_print_start, stdout);

   FILE *f = dylib.fopen (TI_PIO_FILE, "w");
   assert (f);

   r = dylib.fputs (msg_hello, f);
   assert (r >= 0);

   for (int i = 0; i < 32; i++) {
      r = dylib.fputs (dylib.int2str (i), f);
      assert (r >= 0);
      r = dylib.fputs (cr, f);
      assert (r >= 0);
   }

   r = dylib.fclose (f);
   assert (!r);

   return 0;
}
