/* pwd.c
   This program returns the working directory name
   Usage: pwd
   change log:
   08/18/2023 initial version
   11/21/2023 updated to use FILENAME_MAX
   03/07/2024 updated to use dylib
   01/20/2025 moved fputs to dylib
*/ 

#include <unistd.h>
#include <stdio.h>
#include <dylib.h>

int main (int argc, char *argv[]) {
   char cwd[FILENAME_MAX];

   if (dylib.getcwd (cwd, sizeof (cwd))) {
      dylib.fputs (cwd, stdout);
      dylib.fputs ("\n", stdout);
   } else {
      dylib.fputs ("current working directory not set\n", stdout);
   }
   return 0;
}
