/* rmdir.c
   This program removes directories.
   change log:
   05/24/2025 initial version
   05/29/2025 added handling of operation not supported, and printing default unhandled error (when unhandled)
   07/05/2025 added printing of usage when no files are specified
*/

#include <stdio.h>
#include <unistd.h>
#include <unistd.h>
#include <dylib.h>

void print_error (int code, const char *name) {
   dylib.fputs ("rmdir: ", stderr);
   dylib.fputs (name, stderr);
   switch (code) {
      case 1:
         dylib.fputs (": No such file or directory\n", stderr);
         break;
      case 2:
         dylib.fputs (": Directory not empty\n", stderr);
         break;
      case 3:
         dylib.fputs (": Operation not supported\n", stderr);
         break;
      case 4:
         dylib.fputs (": Not a directory\n", stderr);
         break;
      default:
         dylib.fputs (": unhandled error\n", stderr);
         break;
   }
}

void print_usage () {
   dylib.fputs ("usage: rmdir -v dir [...]\n", stderr);
}

int main (int argc, char *argv[]) {

   int r = 0;
   int r2;

   bool verbose = false;
   bool error   = false;

   // capture the options
   int opt;
   while ((opt = getopt (argc, argv, "v")) != -1) {
      switch (opt) {
         case 'v':
            verbose = true;
            break;
         case '?':
         default:
            error = true;
            break;
      }
   }

   // adjust argc and argv removing the processed options
   argc -= optind;
   argv += optind;

   if (error || !argc) {
      print_usage ();
   } else {
      for (int i = 0; i < argc; i++) {
         r2 = rmdir (argv[i]);
         if (r2) {
            print_error (r2, argv[i]);
            r += r2;
         }
      }
   }

   return r;
}
