/* rmuser.c
   This program provides the ability to remove a user account.
   Usage: rmuser username
   change log:
   11/25/2023 initial version
   01/20/2025 updated fputs to dylib
*/

#include <stdbool.h>
#include <stdio.h>
#include <unistd.h>
#include <constants.h>
#include <string.h>
#include <accts_private.h>
#include <dylib.h>

void print_usage () {
   dylib.fputs 
      ("usage: rmuser username\n", 
       stdout);
}

int main (int argc, char *argv[]) {

   int r = UNDEFINED;                      // set to failed by default

   if (argc == 2) {                        // capture the username

      if (getuid () == 0) {                // ensure the user is root

         accts_t accts;                    // accts info
         int ra;

         accts_init (&accts);
         ra = accts_read (&accts);         // read the accounts info
         if (!ra) {
            // remove the user
            ra = accts_rm_user (&accts, argv[1]);
            if (!ra) {
               accts_write (&accts);
               r = 0;
            } else {
               dylib.fputs ("username doesn't exist or can't be removed\n", stderr);
            }

            // free the accounts info
            accts_free (&accts);
         } else {
            dylib.fputs ("can't read passwd file\n", stderr);
         }
      } else {
         dylib.fputs ("rmuser can only be run by root\n", stderr);
      }
   } else {
      print_usage ();
   }

   // return the result
   return r; 
}
