/* shmmgr.c
   This method demonstrates shared memory usage using the shmmgr utilities.

   future enhancements
   use shifts and masks for determining shared memory region, page and index

   change history
   10/09/2025 initial version
   10/22/2025 performance improvements on allocation/deallocation using shifting and masks instead of div and mod
*/

#include <stdlib.h>
#include <dylib.h>
#include <util.h>
#include <conversion.h>

// the main method
int main (int argc, char *argv[]) {

   // the value to be stored

   typedef struct {
      int len;
      char s[126];
   } value_t;

   shmmgr_t shmmgr;

   int r;
   value_t *v;                                                // pointer to an indexed value in shared memory
   int last = -1;

   r = shmmgr_init (&shmmgr, "vi", sizeof (value_t));         // initialize
   if (r) {
      dylib.fputs ("shm_init failed\n", stderr);
      exit (0);
   }

   for (int i = 0; i < 10000; i++) {                          // allocate 2000 items
      r = shmmgr_alloc (&shmmgr);
      if (r >= 0) {
         v = shmmgr_map_and_return_ptr (&shmmgr, r);
         v->len = i;                                          // initialize the length field -- just set to the index for testing
         strcpy (v->s, "Value ");                             // set a string with the index in the text
         strcat (v->s, int2str (r));
         last = r;
      } else {
         break;
      }
   }

   for (r = 0; r <= last; r++) {                              // print all the values stored, to test
      v = shmmgr_map_and_return_ptr (&shmmgr, r);
      dylib.fputs (v->s, stdout);
      dylib.fputs ("\n", stdout);
   }

   shmmgr_term (&shmmgr);                                     // terminate shared memory usage

   return 0;                                                  // return 0 and exit the program
}
