/* shmreader.c
   This method demonstrates the use of shared memory by attaching to an existing shared memory segment.
   change history
   07/12/2025 initial version
*/

#include <sys/ipc.h>
#include <sys/shm.h>
#include <stdlib.h>
#include <dylib.h>
#include <conversion.h>

#define SHM_SIZE 32768

int main (int argc, char *argv[]) {

   key_t key = ftok ("shmfile", 65);

   int shmid = shmget (key, SHM_SIZE, 0); 
   if (shmid == -1) {
      dylib.fputs ("shmget failed\n", stderr);
      exit (1);
   }

   char *str = (char *) 0xf000;
   int i;

   strcpy (str, "XXX");

   for (i = 0; i < SHM_SIZE / 4096 + 1; i++) {
      str = (char*) shmat (shmid, NULL, 0, i);
      if (str == (char*) -1) {
         dylib.fputs ("shmat failed\n", stderr);
         exit (1);
      }

      dylib.fputs (str, stdout);
   }

   int r = shmdt (str);
   if (r) {
      dylib.fputs ("shmdt failed\n", stderr);
      exit (1);
   }

   if (strcmp (str, "XXX")) {
      dylib.fputs ("shmdt didn't restore the default memory map for the page\n", stderr);
   }

   return 0;
}
