/* shmremove.c
   This method demonstrates the use of shared memory by removing an exist shared memory segment.
   change history
   07/12/2025 initial version
*/

#include <sys/ipc.h>
#include <sys/shm.h>
#include <stdlib.h>
#include <dylib.h>
#include <conversion.h>

#define SHM_SIZE 32768

int main (int argc, char *argv[]) {

   key_t key = ftok ("shmfile", 65);

   int shmid = shmget (key, SHM_SIZE, 0); 
   if (shmid == -1) {
      dylib.fputs ("shmget failed\n", stderr);
      exit (1);
   }

   int r = shmctl (shmid, IPC_RMID, NULL);
   if (r) {
      dylib.fputs ("shmctl failed\n", stderr);
      exit (1);
   }

   return 0;
}
