/* shutdown.c
   This method performs system shutdown.
   change history
   05/15/2025 initial version
   06/02/2025 migrated to dylib calls
   06/24/2025 renamed file_is_valid_path to file_has_valid_dsr_name
   07/05/2025 dylib adjustments
   10/13/2025 renamed file_has_valid_dsr_name to file_get_dsr_cru
*/

#include <stdio_private.h>
#include <stdio.h>
#include <console.h>
#include <dylib.h>

int main (int argc, char *argv[]) {
   if (file_get_dsr_cru ("TIPI")) {                 // determine if TIPI exists -- will have a cru

      FILE *f = dylib.fopen ("/PI/SHUTDOWN", "w");
      if (f) {
         dylib.fclose (f);
      }
   }

   long i; 
   for (i = 0; i < 200000; i++) {
      if (i % 20000 == 0) {
         dylib.fputs (".", stdout);
      }
   }

   dylib.fputs ("shutdown complete.\n", stdout);

   while (1);

   return 0;
}
