/* sound.c
   This program provides a simple sound demo.
   change log:
   06/23/2023 initial version
   01/20/2025 moved fputs to dylib
   06/11/2025 removed sound include
*/

#include <vdp.h>
#include <console.h>
#include <stdio.h>
#include <stdbool.h>
#include <soundqueue.h>
#include <sounds.h>
#include <dylib.h>

void test_sound () {

   bool continue_running = true;
   int key;
   int h_mario, h_ominous;
   char *p;
   int len;

   dylib.fputs ("advanced sound player\n\n", stdout);
   dylib.fputs ("press\n1 for super mario\n2 for tipi beeps\n3 for ominimous sound\n", stdout);
   dylib.fputs ("4 for honk\n5 for beep\n6 to exit\n", stdout);

   sounds_get_seq_supermario (&p, &len);
   h_mario = soundqueue_load (p, len, SOUNDQUEUE_PREEMPTION_RULE_CONTINUE);

   sounds_get_seq_ominous_dundundun (&p, &len);
   h_ominous = soundqueue_load (p, len, SOUNDQUEUE_PREEMPTION_RULE_ABORT);

   while (continue_running) {

      key = console_getc ();
      switch (key) {
         case 49:
            soundqueue_play (h_mario);
            break;
         case 50:
            soundqueue_tipi ();
            break;
         case 51:
            soundqueue_play (h_ominous);
            break;
         case 52:
            soundqueue_honk ();
            break;
         case 53:
            soundqueue_beep ();
            break;
         case 54:
            continue_running = false;
            break;
         default:
            break;
      }
   }
}


int main (int argc, char *argv[]) {

   test_sound ();

   return 0;
}
