/* speech.c
   This method tests the speech capabilities.
   change log:
   06/23/2023 initial version
   01/20/2025 updated fputs to use dylib
*/

#include <speech.h>
#include <stdio.h>
#include <speechqueue.h>
#include <console.h>
#include <dylib.h>

int main (int argc, char *argv[]) {
   if (detect_speech()) {
      dylib.fputs ("speech synthesizer detected\n", stdout);
      const int v[] = {VOCAB_TEXAS_INSTRUMENTS, VOCAB_T, VOCAB_I, VOCAB_NINETY, VOCAB_NINE, VOCAB_4, VOCAB_A_ay, 0};
      speechqueue_say_v (v);
      while (!speechqueue_is_empty ()) {
         console_get_key ();
      }
   }
   return 0;
}
