/* sprite.c
   This program tests sprites in standard, f18a text 80 and bitmap display modes
   change log:
   01/11/2025 initial version
   01/13/2025 removed mode parameter from line drawing
   01/20/2025 updated fputs to use dylib
   02/28/2025 updated for removal of 80x30 mode
   06/05/2025 signal handling
   06/07/2025 moved calls to dylib
*/

#include <stdio.h>
#include <stdlib.h>
#include <console.h>
#include <dylib.h>

void sprite_move_around () {
   console_sprite_set_values (0, 0, 15, 0, 0, 0, 0);
   const unsigned char pattern[] = {0xff, 0xff, 0xc3, 0xc3, 0xc3, 0xc3, 0xff, 0xff};
   console_sprite_set_pattern (0, pattern);

   int key;
   int key_last = 0;

   int y_vel = 0;
   int x_vel = 0;

   int cont = 1;
   while (cont) {
      key = console_get_key ();
      if (key != key_last) {
         switch (key) {
            case 'x':
               y_vel++;
               break;
            case 'e':
               y_vel--;
               break;
            case 's':
               x_vel--;
               break;
            case 'd':
               x_vel++;
               break;
            case '1':
               cont = 0;
               break;
            default:
               break;
         }
         console_sprite_set_motion (0, y_vel, x_vel);

         key_last = key;
      }

      if (!cont) {
         break;
      }
   }
}

void sprite_demo_bitmap () {

   console_display_set_mode (DISPLAY_MODE_BITMAP, DISPLAY_ROWS_24);

   // clear the screen
   console_bitmap_cls (CONSOLE_BITMAP_IMAGE_TABLE_FILL_INCREMENTING);

   // set the patterns
   unsigned char char_pattern[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
   console_bitmap_set_all_patterns (char_pattern);

   // set the colors
   unsigned char color_pattern[] = {0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70};
   console_bitmap_set_all_colors (color_pattern);

   console_bitmap_write_text_raw (0, 0, "Sprite Demo - Bitmap");

   for (int i = 10; i < 94; i += 2) {
      console_bitmap_draw_line_right (0 + i, 0 + i, 256 - i * 2);
      console_bitmap_draw_line_right (191 - i, i, 256 - i * 2);
      console_bitmap_draw_line_down (i, i, 192 - i * 2);
      console_bitmap_draw_line_down (i, 255 - i, 192 - i * 2);
   }
 
   sprite_move_around ();
}

void sprite_demo_standard () {
   console_display_set_mode (DISPLAY_MODE_STANDARD, DISPLAY_ROWS_24);
   dylib.fputs ("\f", stdout);
   console_standard_set_default_color ();
   console_fonts_load_std ();
   dylib.fputs ("Sprite Demo - Standard Mode", stdout);
   sprite_move_around ();
}

void sprite_demo_f18text () {
   console_display_set_mode (DISPLAY_MODE_F18A_TEXT80, DISPLAY_ROWS_24);
   dylib.fputs ("\f", stdout);
   console_standard_set_default_color ();
   console_fonts_load_std ();
   dylib.fputs ("\fSprite Demo - F18A Text 80 column", stdout);
   sprite_move_around ();
}

int recover_display_mode;
int recover_display_rows;

// program initialization
void prog_init () {
   console_display_get_mode (&recover_display_mode, &recover_display_rows);
}

// restore settings before exiting
void prog_term () {
   console_display_set_mode (recover_display_mode, recover_display_rows);
   console_cls (); 
   console_standard_set_default_color ();
   console_fonts_load_std ();
}

int main (int argc, char *argv[]) {

   // initialize graphics
   prog_init ();
 
   // set atexit
   dylib.atexit (prog_term);

   // perform the demos
   sprite_demo_standard ();
   sprite_demo_bitmap ();
   sprite_demo_f18text ();
    
   return 0;
}
