/* sptest.c
   This program tests sprites in standard, f18a text 80 and bitmap display modes
   change log:
   01/11/2025 initial version
   01/13/2025 removed mode parameter from line drawing
   01/20/2025 updated fputs to use dylib
   06/05/2025 handle signaling
   06/07/2025 moved calls to dylib
*/

#include <stdio.h>
#include <stdlib.h>
#include <console.h>
#include <dylib.h>

void sprite_move_around () {
   console_sprite_set_values (0, 65, 15, 0, 0, 0, 0);

   int key;
   int key_last = 0;

   int y_vel = 0;
   int x_vel = 0;

   int cont = 1;
   while (cont) {
      key = console_get_key ();
      if (key != key_last) {
         switch (key) {
            case 'x':
               y_vel++;
               break;
            case 'e':
               y_vel--;
               break;
            case 's':
               x_vel--;
               break;
            case 'd':
               x_vel++;
               break;
            case '1':
               cont = 0;
               break;
            default:
               break;
         }
         console_sprite_set_motion (0, y_vel, x_vel);

         key_last = key;
      }

      if (!cont) {
         break;
      }
   }
}

void sprite_demo_standard () {
   console_display_set_mode (DISPLAY_MODE_STANDARD, DISPLAY_ROWS_24);
   dylib.fputs ("\f", stdout);
   console_standard_set_default_color ();
   console_fonts_load_std ();
   dylib.fputs ("Sprite Demo - Standard Mode", stdout);
   sprite_move_around ();
}

// display recover mode
int recover_display_mode;
int recover_display_rows;

void prog_term () {
   // restore settings before exiting
   console_display_set_mode (recover_display_mode, recover_display_rows);
   console_cls (); 
   console_standard_set_default_color ();
   console_fonts_load_std ();
}

int main (int argc, char *argv[]) {

   // save the current display mode
   console_display_get_mode (&recover_display_mode, &recover_display_rows);
 
   // set atexit
   dylib.atexit (prog_term);

   // perform the demos
   sprite_demo_standard ();
    
   return 0;
}
