/* sramtest.c
   This program tests for the scratchpad SRAM expansion and tests it if present.
   Usage: sramtest
   Options:
   (none)
   change log:
   03/29/2025 initial version
*/

#include <stdio.h>
#include <stdbool.h>

int main () {

   int *v;                                                     // read/write address
   int i;                                                      // counter
   bool pass;                                                  // test pass status


   fprintf (stdout, "SRAM 1KB TEST\n\n");                      // write title message

   v = (int *) 0x804A;                                         // write to 0x8?4A incrementing values from 0 to 3
   for (i = 0; i < 4; i++) {
      fprintf (stdout, "write addr %x\n", (unsigned int) v);
      *v = i;
      v += 0x80;
   }

   v = (int *) 0x804A;                                         // test the values written previously
   pass = true;
   for (i = 0; i < 4; i++) {
      pass = pass && (*v == i);
      fprintf (stdout, "test addr %x\n", (unsigned int) v);
      v += 0x80;
   }
   
   fprintf (stdout, "SRAM 1KB? %d\n", pass);                   // print initial test result, which is whether the expansion exists

   if (pass) {                                                 // if the initial test passed, then test all expanded addresses

      v = (int *) 0x8000;                                      // write incrementing values in the address range 0x8000 to 0x82ff
      for (i = 0; i < 384; i++) {                              // note that we're intentionally not testing 0x8300-0x83ff as this 
         *v = i;                                               // range is very much in use by the CPU and the OS
         v++;
      }

      v = (int *) 0x8000;                                      // now test the values written previously
      pass = true;
      for (i = 0; i < 384; i++) {
         pass = pass && (*v == i);
         v++;
      }

      fprintf (stdout, "SRAM 0x8000-0x82FF working? %d\n", pass); // print the result
   }
   
   return 0;                                                   // exit
}
