/* stat.c
   This program provides the file status for the specified files.
   change log:
   05/24/2025 initial version
   06/01/2025 removed debug printing
*/

#include <dsrl2_private.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

int main (int argc, char *argv[]) {

   struct stat mystat;
   int r = 0;
   int r2;

   for (int i = 1; i < argc; i++) {
      r2 = stat (argv[i], &mystat);
      if (!r2) {
         fprintf (stdout, "%ld %d %s\n", mystat.st_size, mystat.st_mode, argv[i]);
      } else {
         fprintf (stderr, "stat: %s: No such file or directory\n", argv[i]);
      }
      r += r2;
   }

   return r;
}
