/*
   tee.c
   This program duplicates standard input writing to the specified file and stdout at the same time.
   Usage: tee file [... filen]
   change log:
   07/01/2023 initial version
   07/10/2023 updated to handle failed file open
   08/11/2023 updated to duplicate the stdin stream to stdout whether or not a file to which to duplicate
              was provided and/or valid.
   08/20/2023 updated to use dylib.fputs rather than fprintf to conserve memory
   02/27/2024 updated to use dylib
   01/20/2025 updated fputs to dylib
   01/20/2025 updated to allow multiple output files
*/

#include <assert.h>
#include <stdio.h>
#include <dylib.h>

int main (int argc, char *argv[]) {

   FILE *f[3];
   char s[256];
   int r;

   int i;
   int file_count = 0;

   // if provided, open file(s) to which to duplicate stdin
   for (i = 1; i < argc; i++) {
      f[i - 1] = dylib.fopen (argv[i], "w");
      if (!f[i - 1]) {
         dylib.fputs ("tee: ", stderr);
         dylib.fputs (argv[i], stderr);
         dylib.fputs (": No such file or directory\n", stderr);
      } else {
         file_count++;
      }
   }

   // process through all of stdin stream
   while (dylib.fgets (s, sizeof (s), stdin)) {

      // write this line to stdout
      r = dylib.fputs (s, stdout);
      assert (r >= 0);

      // if a file is open for duplication of stdin, write to it
      for (i = 0; i < file_count; i++) {
         r = dylib.fputs (s, f[i]);
         assert (r >= 0);
      }
   }

   // close the file if open
   for (i = 0; i < file_count; i++) {
      dylib.fclose (f[i]);
   }

   return 0;
}
