/* test.c
   This method tests text handling within the binary file methods.
   change log:
   12/24/2024 initial version
   01/19/2025 added null termination after reading text using fread
   01/20/2025 moved fputs to dylib
   01/26/2025 added removal of the output file
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <conversion.h>
#include <dylib.h>

int main (int argc, char *argv[]) {

#define FILENAME "out"

   const char *hw = "hello, world!\n";

   FILE *f;
   int r;

   f = dylib.fopen (FILENAME, "wb");
   assert (f);

   r = dylib.fwrite (hw, 1, dylib.strlen (hw), f);
   assert (r == dylib.strlen (hw));

   r = dylib.fclose (f);
   assert (!r);

   int len;
   char *p;

   f = dylib.fopen (FILENAME, "rb");
   assert (f);

   r = dylib.fseek (f, 0, SEEK_END);
   assert (!r);

   len = dylib.ftell (f);
   assert (len >= 0);

   dylib.fputs (dylib.int2str (len), stdout);
   dylib.fputs ("\n", stdout);

   p = malloc (len + 1);
   assert (p);
 
   r = dylib.fseek (f, 0, SEEK_SET);
   assert (!r);

   r = dylib.fread (p, 1, len, f);
   assert (r == len);
   *(p + len) = 0x00;                  // null terminate since fread didn't do that for us :-)

   r = dylib.fclose (f);
   assert (!r);

   dylib.fputs (p, stdout);

   remove (FILENAME);

   return 0;
}
